import { Apple, Mail, Phone, MapPin, Instagram, Facebook, Youtube } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-wellness">
      <div className="container">
        <div className="footer-content-wellness">
          <div className="footer-brand-wellness">
            <div className="footer-logo-wellness">
              <Apple size={24} />
              <span className="footer-logo-text-wellness">NutriWell</span>
            </div>
            <p className="footer-description-wellness">
              Современный подход к питанию и wellness для вашего здоровья
            </p>
          </div>
          <div className="footer-links-wellness">
            <div className="footer-column-wellness">
              <h4 className="footer-title-wellness">Контакты</h4>
              <div className="footer-contact-wellness">
                <div className="footer-contact-item-wellness">
                  <Mail size={16} />
                  <span>info@nutriwell.ru</span>
                </div>
                <div className="footer-contact-item-wellness">
                  <Phone size={16} />
                  <span>+7 (495) 123-45-67</span>
                </div>
                <div className="footer-contact-item-wellness">
                  <MapPin size={16} />
                  <span>Москва, ул. Wellness, 5</span>
                </div>
              </div>
            </div>
            <div className="footer-column-wellness">
              <h4 className="footer-title-wellness">Социальные сети</h4>
              <div className="footer-social-wellness">
                <a href="#" className="footer-social-link-wellness" aria-label="Instagram">
                  <Instagram size={18} />
                </a>
                <a href="#" className="footer-social-link-wellness" aria-label="Facebook">
                  <Facebook size={18} />
                </a>
                <a href="#" className="footer-social-link-wellness" aria-label="YouTube">
                  <Youtube size={18} />
                </a>
              </div>
            </div>
          </div>
        </div>
        <div className="footer-bottom-wellness">
          <p>&copy; 2025 NutriWell. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer
